/* esempio_03_gets
 * Esempio di implementazione della funzione gets (con limite di caratteri, tipo fgets)
 * Aprire il terminale (da "Tools"->"Serial Monitor Ctrl+Maiusc+M" oppure con Control+Maiuscole+M)
 * Ricordarsi di selezionare nel terminale "Newline" nel combp on basso, di fianco alla velocità (9600 baud)
 */

 
void setup () {
  Serial.begin (9600);    // Imposta la velocita' della seriale
}

/* Funzione che legge un carattere;
 * Ritorna quando il carattere e' disponibile 
 * Ritorna: il carattere letto
 */
char getc () {
  int c;
  do {
    c = Serial.read();
  } while (c < 0);
  return c;
}

/* Funzione che legge una stringa fino ad "a capo" o fino a che c'e' spazio;
 * La stringa letta sarà sempre "null terminated"
 * Parametri:
 * buf -> il buffer nel quale inserire la stringa letta
 * buflen -> la massima dimensione della stringa letta (compreso lo 0 di terminazione)
 * Ritorna: l'indirizzo del buffer
 */
char * gets (char *buf, int buflen) {
  int i = 0;
  char c;
  do 
  {
    c = getc();
    buf [i++] = c;
  } while (c != '\n' && i < buflen - 1);
  buf[i]=0;
  return buf;
}

#define MAXSTR  30

void loop () {
  char buff [MAXSTR];
  Serial.println ("Scrivi una stringa");
  gets (buff, MAXSTR);
  Serial.print ("  Hai scritto \"");
  Serial.print (buff);
  Serial.println ("\"");
}

