/* esempio_04_getint
 * Esempio di implementazione della funzione getint che legge un intero da tastiera
 * Aprire il terminale (da "Tools"->"Serial Monitor Ctrl+Maiusc+M" oppure con Control+Maiuscole+M)
 * Ricordarsi di selezionare nel terminale "Newline" nel combp on basso, di fianco alla velocità (9600 baud)
 */

 
void setup () {
  Serial.begin (9600);    // Imposta la velocita' della seriale
}

/* Funzione che legge un carattere;
 * Ritorna quando il carattere e' disponibile 
 * Ritorna: il carattere letto
 */
char getc () {
  int c;
  do {
    c = Serial.read();
  } while (c < 0);
  return c;
}

/* Legge un numero intero positivo da tastiera.
 * Finisce di leggere quando trova un carattere non numerico.
 * Ritorna: l'intero letto
 */
int getint () {
  int i = 0;
  char c;
  do 
  {
    c = getc();
    if (c >= '0'
    && c <= '9') {
      i *= 10;
      i += c - '0';
    }
  } while (c >= '0' && c <= '9');
  return i;
}

void loop () {
  int i;
  Serial.println ("Scrivi un numero intero positivo minore di 32767");
  i = getint ();
  Serial.print ("  Hai scritto ");
  Serial.println (i);
}

