/* esempio_5_test_display
 * test del display sullo shield arduino.
 * accende per 250mS ogni segmento ed il punto
 *
 * Connessioni dello shield e
 *
 * Digital 2 - In   Tasto S3
 * Digital 4 [3] - Out  Segmento e
 * Digital 3 [4]4 - In   Tasto S2
 * Digital 5 - Out  Segmento d
 * Digital 6 - Out  Segmento c
 * Digital 7 - Out  dp - Punto Decimale
 * Digital 8 - In   Tasto S1
 * Digital 9 - Out  Segmento b
 * Digital 10 - Out Segmento a
 * Digital 11 - Out Segmento f
 * Digital 12 - Out Segmento g
 * Analog 0 - Fotoresistenza - Luce
 * Analog 1 - NTC - Temperatura
 *     --a--
 *    |     |
 *    f     b
 *    |     |
 *     --g--
 *    |     |
 *    e     c
 *    |     |
 *     --d--  dp
 */

#define LEDPIN  13

#define  APIN   10
#define  BPIN   9
#define  CPIN   6
#define  DPIN   5
#define  EPIN   4 /* 3 */
#define  FPIN   11
#define  GPIN   12
#define  DPPIN  7
#define  S1PIN  8
#define  S2PIN  3 /* 4 */
#define  S3PIN  2
#define  LUCE   1
#define  TEMP   0

#define  NUMSEGS  8

/* Array dei numeri di piedino, per ogni segmento del display */
char segments [] = {
  APIN,
  BPIN,
  CPIN,
  DPIN,
  EPIN,
  FPIN,
  GPIN,
  DPPIN  
};

void setup () {
  int i;

  for (i = 0; i < NUMSEGS; i++) {
    pinMode(segments [i], OUTPUT);      // Imposta il piedino del segmento a in uscita
    digitalWrite(segments [i], HIGH);   // Spegne il LED
  }
}

void loop () {
  int i;
  for (i = 0; i < NUMSEGS; i++) {
    digitalWrite(segments [i], LOW);    // Accende il LED
    delay (250);                        // Attende 1/4 di secondo
    digitalWrite(segments [i], HIGH);   // Spegne il LED
  }
}



