/* esempio_09_PWM
 * Regola la luminosita' di alcuni segmenti
 *
 * Connessioni dello shield e
 *
 * Digital 2 - In   Tasto S3
 * Difital 4 [3] - Out  Segmento e
 * Digital 3 [4] - In   Tasto S2
 * Digital 5 - Out  Segmento d
 * Digital 6 - Out  Segmento c
 * Digital 7 - Out  dp - Punto Decimale
 * Digital 8 - In   Tasto S1
 * Digital 9 - Out  Segmento b
 * Digital 10 - Out Segmento a
 * Digital 11 - Out Segmento f
 * Digital 12 - Out Segmento g
 * Analog 0 - Fotoresistenza - Luce
 * Analog 1 - NTC - Temperatura
 *     --a--
 *    |     |
 *    f     b
 *    |     |
 *     --g--
 *    |     |
 *    e     c
 *    |     |
 *     --d--  dp
 */

#define LEDPIN  13

#define  APIN   10
#define  BPIN   9
#define  CPIN   6
#define  DPIN   5
#define  EPIN   4 /* 3 */
#define  FPIN   11
#define  GPIN   12
#define  DPPIN  7
#define  S1PIN  8
#define  S2PIN  3 /* 4 */
#define  S3PIN  2
#define  LUCE   1
#define  TEMP   0

#define  NUMSEGS  8

/* Array dei numeri di piedino, per ogni segmento del display */
char segments [] = {
  APIN,
  BPIN,
  CPIN,
  DPIN,
  EPIN,
  FPIN,
  GPIN,
  DPPIN  
};

void setup () {
  int i;

  for (i = 0; i < NUMSEGS; i++) {
    pinMode(segments [i], OUTPUT);  // Imposta il piedino del segmento a in uscita
    digitalWrite(segments [i], HIGH);   // Spegne il LED
  }
  /* Modificato da esempio_06_conteggio */
  /* Configura in input i piedini dei tre pulsanti */
  pinMode(S1PIN, INPUT);
  pinMode(S2PIN, INPUT);
  pinMode(S3PIN, INPUT);
  /* fine modifica da esempio_06_conteggio */
}
/***** fine copia da esempio_06_conteggio *****/

void luce (int i) {  // 1 da 0 a 15
  i %= 16;
  i *= 16;
  analogWrite (APIN,i);
  analogWrite (BPIN,i);
  analogWrite (CPIN,i);
  analogWrite (DPIN,i);
  // analogWrite (EPIN,i);
  analogWrite (FPIN,i);
}

void loop () {
  static unsigned int i = 8;
  
  luce (i);
  if (!digitalRead(S1PIN)) {  // Pulsante 1 premuto
    delay(10);  // Ritardo per attendere la fine dei rimbalzi
    if (!digitalRead(S1PIN)) {  // Il tasto e' ancora premuto
      i = (i + 1) % 16;
      luce (i);
      while (!digitalRead(S1PIN));  // Attende il rilascio
    }
  }
  if (!digitalRead(S2PIN)) {  // Pulsante 1 premuto
    delay(10);  // Ritardo per attendere la fine dei rimbalzi
    if (!digitalRead(S2PIN)) {  // Il tasto e' ancora premuto
      i = 8;
      luce (i);
      while (!digitalRead(S2PIN));  // Attende il rilascio
    }
  }
  if (!digitalRead(S3PIN)) {  // Pulsante 1 premuto
    delay(10);  // Ritardo per attendere la fine dei rimbalzi
    if (!digitalRead(S3PIN)) {  // Il tasto e' ancora premuto
      i = (i - 1) % 16;
      luce (i);
      while (!digitalRead(S3PIN));  // Attende il rilascio
    }
  }
}



