/* esercizio_01_sos
 * Scketch di esempio
 *
 * fa lampeggiare il LED con il pattern del segnale MORDE di SOS
 */

/* Il LED giallo chiamato 'L', a sinistra, sopra il connettore USB
 * Ã¨ connesso al piedino DIGITALE 13.
 */
#define LEDPIN  13

#define  DOTLEN      100
#define  LINELEN     300
#define  PAUSELEN    100
#define  LETTERPLUS  200
#define  WORDPLUS    200

void dot ();
void line ();
void letterSep ();
void wordSep ();
void letterS ();
void letterO ();

/* Questa funzione viene chiamata per impostare la scheda, una sola volta
 */
void setup () {
  pinMode(LEDPIN, OUTPUT);  // Imposta il piedino del LED 'L' in uscita
}

/* Questa funzione viene ripetuta all'infinito
 */
void loop () {
  letterS ();  // S
  letterO ();  // O
  letterS ();  // S
  wordSep ();  // Separa le parole
}

void dot () {
  digitalWrite(LEDPIN, HIGH);   // Accende il LED 'L'
  delay (DOTLEN);               // Attende tempo di punto
  digitalWrite(LEDPIN, LOW);    // Spegne il LED 'L'
  delay (PAUSELEN);             // pausa tra simboli
}

void line () {
  digitalWrite(LEDPIN, HIGH);   // Accende il LED 'L'
  delay (LINELEN);              // tempo di linea
  digitalWrite(LEDPIN, LOW);    // Spegne il LED 'L'
  delay (PAUSELEN);             // Attende pausa tra simboli
}

void letterSep () {
  delay (LETTERPLUS);            // Attende ancora un po' per arrivare alla pausa tra lettere
}

void wordSep () {
  delay (WORDPLUS);            // Attende ancora un po' per arrivare alla pausa tra lettere
}

void letterS () {
  dot ();
  dot ();
  dot ();
  letterSep ();
}

void letterO () {
  line ();
  line ();
  line ();
  letterSep ();
}



