/* esercizio_7_fotoresistenza_limiti
 * Misuratore di luce
 * Sfruttando la decodifica dell'esempio precedente
 * visualizza il livello di luce misurato dalla fotoresistenza
 *
 * Connessioni dello shield e
 *
 * Digital 2 - In   Tasto S3
 * Difital 4 [3] - Out  Segmento e
 * Digital 3 [4] - In   Tasto S2
 * Digital 5 - Out  Segmento d
 * Digital 6 - Out  Segmento c
 * Digital 7 - Out  dp - Punto Decimale
 * Digital 8 - In   Tasto S1
 * Digital 9 - Out  Segmento b
 * Digital 10 - Out Segmento a
 * Digital 11 - Out Segmento f
 * Digital 12 - Out Segmento g
 * Analog 0 - Fotoresistenza - Luce
 * Analog 1 - NTC - Temperatura
 *     --a--
 *    |     |
 *    f     b
 *    |     |
 *     --g--
 *    |     |
 *    e     c
 *    |     |
 *     --d--  dp
 */

#define LEDPIN  13

#define  APIN   10
#define  BPIN   9
#define  CPIN   6
#define  DPIN   5
#define  EPIN   4 /* 3 */
#define  FPIN   11
#define  GPIN   12
#define  DPPIN  7
#define  S1PIN  8
#define  S2PIN  3 /* 4 */
#define  S3PIN  2
#define  LUCE   1
#define  TEMP   0

#define  NUMSEGS  8

/* Array dei numeri di piedino, per ogni segmento del display */
char segments [] = {
  APIN,
  BPIN,
  CPIN,
  DPIN,
  EPIN,
  FPIN,
  GPIN,
  DPPIN  
};

/* Matrice di decodifica da esadecimale allo stato dei segmenti */
boolean cifre [16][7] = {
// a     b      c      d      e      f      g
  {true,  true,  true,  true,  true,  true,  false },  // 0
  {false, true,  true,  false, false, false, false },  // 1
  {true,  true,  false, true,  true,  false, true },   // 2
  {true,  true,  true,  true,  false, false, true },   // 3
  {false, true,  true,  false, false, true,  true },   // 4
  {true,  false, true,  true,  false, true,  true },   // 5
  {true,  false, true,  true,  true,  true,  true },   // 6
  {true,  true,  true,  false, false, false, false },  // 7
  {true,  true,  true,  true,  true,  true,  true },   // 8
  {true,  true,  true,  true,  false,  true,  true },  // 9
  {true,  true,  true,  false, true,  true,  true },   // A
  {false, false, true,  true,  true,  true,  true },   // B
  {true,  false, false, true,  true,  true,  false },  // C  
  {false, true,  true,  true,  true,  false,  true },  // D
  {true,  false, false, true,  true,  true,  true },   // E  
  {true,  false, false, false, true,  true,  true },   // F 
};

void setup () {
  int i;

  Serial.begin (9600);    // Imposta la velocita' della seriale

  for (i = 0; i < NUMSEGS; i++) {
    pinMode(segments [i], OUTPUT);  // Imposta il piedino del segmento a in uscita
    digitalWrite(segments [i], HIGH);   // Spegne il LED
  }
}

/* Funzione che visualizza un numero sul display
 * Parametri:
 * n -> il numero da visualizzare (limitato a 0-15)
 * Ritorna:
 * niente
 */
void digit (int n) {
  int i;
  n = n % 16;  // limita ad una cifra
  for (i = 0; i < 7; i++) {
    digitalWrite(segments [i], (cifre[n][i]) ? LOW : HIGH);   // Accende il LED
  }
}

int minimo = 0;
int massimo = 1023;

void loop () {
  int i;
  i = analogRead(LUCE);
  
  if (!digitalRead(S1PIN) && i < massimo) {
    minimo = i;
  }
  if (!digitalRead(S3PIN) && i > minimo) {
    massimo = i;
  }
  if (!digitalRead(S2PIN)) {
    massimo = 1023;
    minimo = 0;
  }
  
  if (i < minimo) {
    digit (0);
  } if (i > massimo) {
    digit (15);
  } else {
    digit ((i-minimo)/((massimo - minimo) / 16));  // La lettura e' tra 0 e 1024 - riscalo in base a minimo e massimo
  }
  Serial.print ("Valore di luce letto: ");
  Serial.print (i);
  Serial.print (" minimo impostato: ");
  Serial.print (minimo);
  Serial.print (" massimo impostato: ");
  Serial.println (massimo);
  delay (500);
}



